ORCA/M Asm65816 2.1.0

0001 24D0                       title 'QD SLABS             GS ROM 3.0'
0002 24D0              ****************************************************************
0003 24D0              *                                                              *
0004 24D0              *                   SLABS                                      *
0005 24D0              *                                                              *
0006 24D0              ****************************************************************
0007 24D0
0008 24D0
0009 24D0              ****************************************************************
0010 24D0              *                                                              *
0011 24D0              *                   Copyright (C) 1985-1988                    *
0012 24D0              *                   All Rights Reserved                        *
0013 24D0              *                   Apple Computer, Inc.                       *
0014 24D0              *                                                              *
0015 24D0              ****************************************************************
0016 24D0
0017 24D0
0018 24D0              **********************************************************************
0019 24D0              *
0020 24D0              * Change History
0021 24D0              *
0022 24D0              * 9 Sep 88          Steven Glass
0023 24D0              *
0024 24D0              * Rewrote slab routines to use both words of Pat no matter what the
0025 24D0              * mode.
0026 24D0              *
0027 24D0              * Unwound the loop in FastSlabCopy and FastSlabXOR for case where
0028 24D0              * Pat and Pat+2 are the same.
0029 24D0              *
0030 24D0              * 2/1/89            Mensch
0031 24D0              *
0032 24D0              * Modified a few of the fast slab routines so they use a faster addressing mode
0033 24D0              *
0034 24D0              *
0035 24D0              * 2/13/89           Dave Good
0036 24D0              *
0037 24D0              * Changed the FastSlabCopy and FastSlabXOR routines to save a few bytes
0038 24D0              * and cycles
0039 24D0              *
0040 24D0              * 4/22/89           Mensch
0041 24D0              * 
0042 24D0              * Added SwapPat macro to test the startword and swap pat and pat+2 if the
0043 24D0              * startwprd starts on an odd word. This should fix 320 pattern fills and
0044 24D0              * 640 mode pattern fills that use arcrot.
0045 24D0              *
0046 24D0              **********************************************************************
0047 24D0
0048 24D0
0049 24D0                       blanks off 
0050 24D0                       string asis 
0051 24D0
0052 24D0                       include 'all.macros' 
0053 24D0                       include ':QDEquates:qd.data.asm' 
0054 24D0
0055 24D0
0056 24D0                       INCLUDE ':QDEquates:CORE.GLOBALS1' 
0057 24D0                       INCLUDE ':QDEquates:core.globals2' 
0058 24D0                       INCLUDE ':QDEquates:region.equs' 
0059 24D0                       INCLUDE ':QDEquates:RECT.EQUS' 
0060 24D0                       INCLUDE ':QDEquates:SLAB.EQUS' 
0061 24D0
0062 24D0              ****************************************************************
0063 24D0              *
0064 24D0              * All the slab routines use the same data on zero page.
0065 24D0              *
0066 24D0              * Before any slab routine is called, the data bank register
0067 24D0              * is set to the bank containing the pixel map.
0068 24D0              *
0069 24D0              * The following are set up on zero page before this routine
0070 24D0              * is called:
0071 24D0              *
0072 24D0              * Inputs:
0073 24D0              *
0074 24D0              *    LeftMask      The Pixels not being touched on the left are
0075 24D0              *                  set to zero in this word mask.
0076 24D0              *
0077 24D0              *    RightMask     The Pixels not being touched on the right are
0078 24D0              *                  set to zero in this word mask
0079 24D0              *
0080 24D0              *    StartWord     The First word on the scan line to deal with
0081 24D0              *
0082 24D0              *    FinishWord    The last word on the scan line to deal with
0083 24D0              *
0084 24D0              *    ScanMaskRef   Points to the global scan line clip buffer
0085 24D0              *
0086 24D0              *    DestRef       Points to the start of the current scan line
0087 24D0              *                  (or scan line equiv since can draw into mem).
0088 24D0              *
0089 24D0              *    PatMask       A mask to use with current index into scan line
0090 24D0              *                  to produce an index into Pat.  In 320 mode,
0091 24D0              *                  PatMask AND Index will yield 0 or 2.  In 640 mode
0092 24D0              *                  it will always yield 0 since pattern fits in
0093 24D0              *                  one word
0094 24D0              *
0095 24D0              *    Pat           Two words to hold the current part of the
0096 24D0              *                  pattern being used for this scan line.
0097 24D0              *
0098 24D0              *    DrawMask      Two words to hold the current slice of the
0099 24D0              *                  of the drawing mask.
0100 24D0              *
0101 24D0              *
0102 24D0              ****************************************************************
0103 24D0
0104 24D0
0105 24D0                       title 'SlabCopy'
0106 24D0              ****************************************************************
0107 24D0              *
0108 24D0              SlabCopy PROC EXPORT 
0109 24D0              *
0110 24D0              * This is the routine that is called to copy patterns to
0111 24D0              * the destination when the regions are non-rectangular or the
0112 24D0              * penmask is not all $FFFF's.
0113 24D0              *
0114 24D0              *
0115 24D0              * Inputs:
0116 24D0              *
0117 24D0              *    LeftMask      The Pixels not being touched on the left are
0118 24D0              *                  set to zero in this word mask.
0119 24D0              *
0120 24D0              *    RightMask     The Pixels not being touched on the right are
0121 24D0              *                  set to zero in this word mask
0122 24D0              *
0123 24D0              *    StartWord     The First word on the scan line to deal with
0124 24D0              *
0125 24D0              *    FinishWord    The last word on the scan line to deal with
0126 24D0              *
0127 24D0              *    ScanMaskRef   Points to the global scan line clip buffer
0128 24D0              *
0129 24D0              *    DestRef       Points to the start of the current scan line
0130 24D0              *                  (or scan line equiv since can draw into mem).
0131 24D0              *
0132 24D0              *    PatMask       A mask to use with current index into scan line
0133 24D0              *                  to produce an index into Pat.  In 320 mode,
0134 24D0              *                  PatMask AND Index will yield 0 or 2.  In 640 mode
0135 24D0              *                  it will always yield 0 since pattern fits in
0136 24D0              *                  one word
0137 24D0              *
0138 24D0              *    Pat           Two words to hold the current part of the
0139 24D0              *                  pattern being used for this scan line.
0140 24D0              *
0141 24D0              *    DrawMask      Two words to hold the current slice of the
0142 24D0              *                  of the drawing mask.
0143 24D0              *
0144 24D0              *
0145 24D0              *
0146 24D0              * Outputs:
0147 24D0              *                   none
0148 24D0              *
0149 24D0              * External Refs:
0150 24D0              *                   none
0151 24D0              *
0152 24D0              * Entry Points:
0153 24D0              *                   none
0154 24D0              *
0155 24D0                       longa on                       ; mode
0156 24D0                       longi on
0157 24D0              *
0158 24D0              * Change History
0159 24D0              *
0160 24D0              * 08 Sep 88         Steven Glass
0161 24D0              *
0162 24D0              * Unwound the loop some and took advantage of the expanded
0163 24D0              * pattern.
0164 24D0              *
0165 24D0              * No counters are kept on direct page.
0166 24D0              *
0167 24D0              ****************************************************************
0168 24D0
0169 24D0 A5 C4 29 02           SwapPat 
0170 24DF
0171 24DF A5 C6                 lda   FinishWord               ; put count in x-register
0172 24E1 38                    sec   
0173 24E2 E5 C4                 sbc   StartWord
0174 24E4 4A                    lsr   a                        ; make this num words to xfer - 1
0175 24E5 AA                    tax   
0176 24E6
0177 24E6 A4 C4                 ldy   StartWord                ; get the start word in y
0178 24E8 A5 CA                 lda   Pat                      ; source pattern in a-reg
0179 24EA 51 BC                 eor   (DestRef),y              ; invert with dest
0180 24EC 25 A0                 and   LeftMask
0181 24EE E0 00 00              cpx   #0                       ; check for special case where only 1 word
0182 24F1 D0 02                 bne   @MoreThanOne
0183 24F3 25 A2                 and   RightMask
0184 24F5 37 4C        @MoreThanOne and   [ScanMaskRef],y      ; do masking
0185 24F7 25 CE                 and   DrawMask
0186 24F9 51 BC                 eor   (DestRef),y              ; invert again
0187 24FB 91 BC                 sta   (DestRef),y              ; and store
0188 24FD
0189 24FD E0 00 00              cpx   #0
0190 2500 F0 38                 beq   AllDone
0191 2502
0192 2502 C8                    iny                            ; bump y and but don't touch x yet
0193 2503 C8                    iny   
0194 2504 E0 01 00              cpx   #1                       ; if x is 1 there is one word to go
0195 2507 F0 23                 beq   DoLastWord2
0196 2509
0197 2509 CA                    dex   
0198 250A
0199 250A              InnerLoop  
0200 250A A5 CC                 lda   Pat+2                    ; source pattern in a-reg
0201 250C 51 BC                 eor   (DestRef),y              ; invert with dest
0202 250E 37 4C                 and   [ScanMaskRef],y          ; do masking
0203 2510 25 D0                 and   DrawMask+2
0204 2512 51 BC                 eor   (DestRef),y              ; invert again
0205 2514 91 BC                 sta   (DestRef),y              ; and store
0206 2516
0207 2516 C8                    iny                            ; bump y
0208 2517 C8                    iny   
0209 2518
0210 2518 CA                    dex                            ; dec x
0211 2519 F0 2F                 beq   DoLastWord1              ; if x is zero there is one word to go
0212 251B
0213 251B A5 CA                 lda   Pat
0214 251D 51 BC                 eor   (DestRef),y
0215 251F 37 4C                 and   [ScanMaskRef],y
0216 2521 25 CE                 and   DrawMask
0217 2523 51 BC                 eor   (DestRef),y
0218 2525 91 BC                 sta   (DestRef),y
0219 2527
0220 2527 C8                    iny   
0221 2528 C8                    iny   
0222 2529 CA                    dex   
0223 252A D0 DE                 bne   InnerLoop                ; if x is zero there is one word to go
0224 252C
0225 252C
0226 252C              DoLastWord2  
0227 252C A5 CC                 lda   Pat+2                    ; source pattern in a-reg
0228 252E 51 BC                 eor   (DestRef),y              ; invert with dest
0229 2530 25 A2                 and   RightMask
0230 2532 37 4C                 and   [ScanMaskRef],y          ; do masking
0231 2534 25 D0                 and   DrawMask+2
0232 2536 51 BC                 eor   (DestRef),y              ; invert again
0233 2538 91 BC                 sta   (DestRef),y              ; and store
0234 253A
0235 253A              AllDone   
0236 253A A5 C4 29 02           SwapPat 
0237 2549 6B                    rtl   
0238 254A
0239 254A              DoLastWord1  
0240 254A A5 CA                 lda   Pat                      ; source pattern in a-reg
0241 254C 51 BC                 eor   (DestRef),y              ; invert with dest
0242 254E 25 A2                 and   RightMask
0243 2550 37 4C                 and   [ScanMaskRef],y          ; do masking
0244 2552 25 CE                 and   DrawMask
0245 2554 51 BC                 eor   (DestRef),y              ; invert again
0246 2556 91 BC                 sta   (DestRef),y              ; and store
0247 2558 A5 C4 29 02           SwapPat 
0248 2567 6B                    rtl   
0249 2568
0250 2568
0251 2568
0252 2568
0253 2568                       ENDP 
0254 2568
0255 2568
0256 2568                       title 'SlabOR'
0257 2568              ****************************************************************
0258 2568              *
0259 2568              SlabOR   PROC EXPORT 
0260 2568              *
0261 2568              * This is the routine that is called to OR patterns to
0262 2568              * the destination when the regions are non-rectangular or the
0263 2568              * penmask is not all $FFFF's.
0264 2568              *
0265 2568              *
0266 2568              * Inputs:
0267 2568              *
0268 2568              *    LeftMask      The Pixels not being touched on the left are
0269 2568              *                  set to zero in this word mask.
0270 2568              *
0271 2568              *    RightMask     The Pixels not being touched on the right are
0272 2568              *                  set to zero in this word mask
0273 2568              *
0274 2568              *    StartWord     The First word on the scan line to deal with
0275 2568              *
0276 2568              *    FinishWord    The last word on the scan line to deal with
0277 2568              *
0278 2568              *    ScanMaskRef   Points to the global scan line clip buffer
0279 2568              *
0280 2568              *    DestRef       Points to the start of the current scan line
0281 2568              *                  (or scan line equiv since can draw into mem).
0282 2568              *
0283 2568              *    PatMask       A mask to use with current index into scan line
0284 2568              *                  to produce an index into Pat.  In 320 mode,
0285 2568              *                  PatMask AND Index will yield 0 or 2.  In 640 mode
0286 2568              *                  it will always yield 0 since pattern fits in
0287 2568              *                  one word
0288 2568              *
0289 2568              *    Pat           Two words to hold the current part of the
0290 2568              *                  pattern being used for this scan line.
0291 2568              *
0292 2568              *    DrawMask      Two words to hold the current slice of the
0293 2568              *                  of the drawing mask.
0294 2568              *
0295 2568              *
0296 2568              *
0297 2568              * Outputs:
0298 2568              *                   none
0299 2568              *
0300 2568              * External Refs:
0301 2568              *                   none
0302 2568              *
0303 2568              * Entry Points:
0304 2568              *                   none
0305 2568              *
0306 2568                       longa on                       ; mode
0307 2568                       longi on
0308 2568              *
0309 2568              * Change History
0310 2568              *
0311 2568              * 08 Sep 88         Steven Glass
0312 2568              *
0313 2568              * Unwound the loop some and took advantage of the expanded
0314 2568              * pattern.
0315 2568              *
0316 2568              * No counters are kept on direct page.
0317 2568              *
0318 2568              ****************************************************************
0319 2568
0320 2568 A5 C4 29 02           swapPat 
0321 2577
0322 2577 A5 C6                 lda   FinishWord               ; put count in x-register
0323 2579 38                    sec   
0324 257A E5 C4                 sbc   StartWord
0325 257C 4A                    lsr   a                        ; make this num words to xfer - 1
0326 257D AA                    tax   
0327 257E
0328 257E A4 C4                 ldy   StartWord                ; get the start word in y
0329 2580 A5 CA                 lda   Pat                      ; source pattern in a-reg
0330 2582 25 A0                 and   LeftMask
0331 2584 E0 00 00              cpx   #0                       ; check for special case where only 1 word
0332 2587 D0 02                 bne   @MoreThanOne
0333 2589 25 A2                 and   RightMask
0334 258B 37 4C        @MoreThanOne and   [ScanMaskRef],y      ; do masking
0335 258D 25 CE                 and   DrawMask
0336 258F 11 BC                 ora   (DestRef),y              ; OR
0337 2591 91 BC                 sta   (DestRef),y              ; and store
0338 2593
0339 2593 E0 00 00              cpx   #0
0340 2596 F0 32                 beq   AllDone
0341 2598
0342 2598 C8                    iny                            ; bump y and but don't touch x yet
0343 2599 C8                    iny   
0344 259A E0 01 00              cpx   #1                       ; if x is 1 there is one word to go
0345 259D F0 1F                 beq   DoLastWord2
0346 259F
0347 259F CA                    dex   
0348 25A0
0349 25A0              InnerLoop  
0350 25A0 A5 CC                 lda   Pat+2                    ; source pattern in a-reg
0351 25A2 37 4C                 and   [ScanMaskRef],y          ; do masking
0352 25A4 25 D0                 and   DrawMask+2
0353 25A6 11 BC                 ora   (DestRef),y              ; OR
0354 25A8 91 BC                 sta   (DestRef),y              ; and store
0355 25AA
0356 25AA C8                    iny                            ; bump y
0357 25AB C8                    iny   
0358 25AC
0359 25AC CA                    dex                            ; dec x
0360 25AD F0 2B                 beq   DoLastWord1              ; if x is zero there is one word to go
0361 25AF
0362 25AF A5 CA                 lda   Pat
0363 25B1 37 4C                 and   [ScanMaskRef],y
0364 25B3 25 CE                 and   DrawMask
0365 25B5 11 BC                 ora   (DestRef),y
0366 25B7 91 BC                 sta   (DestRef),y
0367 25B9
0368 25B9 C8                    iny   
0369 25BA C8                    iny   
0370 25BB CA                    dex   
0371 25BC D0 E2                 bne   InnerLoop                ; if x is zero there is one word to go
0372 25BE
0373 25BE
0374 25BE              DoLastWord2  
0375 25BE A5 CC                 lda   Pat+2                    ; source pattern in a-reg
0376 25C0 25 A2                 and   RightMask
0377 25C2 37 4C                 and   [ScanMaskRef],y          ; do masking
0378 25C4 25 D0                 and   DrawMask+2
0379 25C6 11 BC                 ora   (DestRef),y              ; invert again
0380 25C8 91 BC                 sta   (DestRef),y              ; and store
0381 25CA
0382 25CA              AllDone   
0383 25CA A5 C4 29 02           SwapPat 
0384 25D9 6B                    rtl   
0385 25DA
0386 25DA              DoLastWord1  
0387 25DA A5 CA                 lda   Pat                      ; source pattern in a-reg
0388 25DC 25 A2                 and   RightMask
0389 25DE 37 4C                 and   [ScanMaskRef],y          ; do masking
0390 25E0 25 CE                 and   DrawMask
0391 25E2 11 BC                 ora   (DestRef),y              ; invert again
0392 25E4 91 BC                 sta   (DestRef),y              ; and store
0393 25E6 A5 C4 29 02           SwapPat 
0394 25F5 6B                    rtl   
0395 25F6
0396 25F6
0397 25F6
0398 25F6
0399 25F6                       ENDP 
0400 25F6
0401 25F6                       title 'SlabXOR'
0402 25F6              ****************************************************************
0403 25F6              *
0404 25F6              SlabXOR  PROC EXPORT 
0405 25F6              *
0406 25F6              * This is the routine that is called to XOR patterns to
0407 25F6              * the destination when the regions are non-rectangular or the
0408 25F6              * penmask is not all $FFFF's.
0409 25F6              *
0410 25F6              *
0411 25F6              * Inputs:
0412 25F6              *
0413 25F6              *    LeftMask      The Pixels not being touched on the left are
0414 25F6              *                  set to zero in this word mask.
0415 25F6              *
0416 25F6              *    RightMask     The Pixels not being touched on the right are
0417 25F6              *                  set to zero in this word mask
0418 25F6              *
0419 25F6              *    StartWord     The First word on the scan line to deal with
0420 25F6              *
0421 25F6              *    FinishWord    The last word on the scan line to deal with
0422 25F6              *
0423 25F6              *    ScanMaskRef   Points to the global scan line clip buffer
0424 25F6              *
0425 25F6              *    DestRef       Points to the start of the current scan line
0426 25F6              *                  (or scan line equiv since can draw into mem).
0427 25F6              *
0428 25F6              *    PatMask       A mask to use with current index into scan line
0429 25F6              *                  to produce an index into Pat.  In 320 mode,
0430 25F6              *                  PatMask AND Index will yield 0 or 2.  In 640 mode
0431 25F6              *                  it will always yield 0 since pattern fits in
0432 25F6              *                  one word
0433 25F6              *
0434 25F6              *    Pat           Two words to hold the current part of the
0435 25F6              *                  pattern being used for this scan line.
0436 25F6              *
0437 25F6              *    DrawMask      Two words to hold the current slice of the
0438 25F6              *                  of the drawing mask.
0439 25F6              *
0440 25F6              *
0441 25F6              *
0442 25F6              * Outputs:
0443 25F6              *                   none
0444 25F6              *
0445 25F6              * External Refs:
0446 25F6              *                   none
0447 25F6              *
0448 25F6              * Entry Points:
0449 25F6              *                   none
0450 25F6              *
0451 25F6                       longa on                       ; mode
0452 25F6                       longi on
0453 25F6              *
0454 25F6              * Change History
0455 25F6              *
0456 25F6              * 08 Sep 88         Steven Glass
0457 25F6              *
0458 25F6              * Unwound the loop some and took advantage of the expanded
0459 25F6              * pattern.
0460 25F6              *
0461 25F6              * No counters are kept on direct page.
0462 25F6              *
0463 25F6              ****************************************************************
0464 25F6
0465 25F6 A5 C4 29 02           swapPat 
0466 2605
0467 2605 A5 C6                 lda   FinishWord               ; put count in x-register
0468 2607 38                    sec   
0469 2608 E5 C4                 sbc   StartWord
0470 260A 4A                    lsr   a                        ; make this num words to xfer - 1
0471 260B AA                    tax   
0472 260C
0473 260C A4 C4                 ldy   StartWord                ; get the start word in y
0474 260E A5 CA                 lda   Pat                      ; source pattern in a-reg
0475 2610 25 A0                 and   LeftMask
0476 2612 E0 00 00              cpx   #0                       ; check for special case where only 1 word
0477 2615 D0 02                 bne   @MoreThanOne
0478 2617 25 A2                 and   RightMask
0479 2619 37 4C        @MoreThanOne and   [ScanMaskRef],y      ; do masking
0480 261B 25 CE                 and   DrawMask
0481 261D 51 BC                 eor   (DestRef),y              ; XOR
0482 261F 91 BC                 sta   (DestRef),y              ; and store
0483 2621
0484 2621 E0 00 00              cpx   #0
0485 2624 F0 32                 beq   AllDone
0486 2626
0487 2626 C8                    iny                            ; bump y and but don't touch x yet
0488 2627 C8                    iny   
0489 2628 E0 01 00              cpx   #1                       ; if x is 1 there is one word to go
0490 262B F0 1F                 beq   DoLastWord2
0491 262D
0492 262D CA                    dex   
0493 262E
0494 262E              InnerLoop  
0495 262E A5 CC                 lda   Pat+2                    ; source pattern in a-reg
0496 2630 37 4C                 and   [ScanMaskRef],y          ; do masking
0497 2632 25 D0                 and   DrawMask+2
0498 2634 51 BC                 eor   (DestRef),y              ; EOR
0499 2636 91 BC                 sta   (DestRef),y              ; and store
0500 2638
0501 2638 C8                    iny                            ; bump y
0502 2639 C8                    iny   
0503 263A
0504 263A CA                    dex                            ; dec x
0505 263B F0 2B                 beq   DoLastWord1              ; if x is zero there is one word to go
0506 263D
0507 263D A5 CA                 lda   Pat
0508 263F 37 4C                 and   [ScanMaskRef],y
0509 2641 25 CE                 and   DrawMask
0510 2643 51 BC                 eor   (DestRef),y
0511 2645 91 BC                 sta   (DestRef),y
0512 2647
0513 2647 C8                    iny   
0514 2648 C8                    iny   
0515 2649 CA                    dex   
0516 264A D0 E2                 bne   InnerLoop                ; if x is zero there is one word to go
0517 264C
0518 264C
0519 264C              DoLastWord2  
0520 264C A5 CC                 lda   Pat+2                    ; source pattern in a-reg
0521 264E 25 A2                 and   RightMask
0522 2650 37 4C                 and   [ScanMaskRef],y          ; do masking
0523 2652 25 D0                 and   DrawMask+2
0524 2654 51 BC                 eor   (DestRef),y              ; XOR
0525 2656 91 BC                 sta   (DestRef),y              ; and store
0526 2658
0527 2658 A5 C4 29 02  AllDone  SwapPat 
0528 2667 6B                    rtl   
0529 2668
0530 2668
0531 2668              DoLastWord1  
0532 2668 A5 CA                 lda   Pat                      ; source pattern in a-reg
0533 266A 25 A2                 and   RightMask
0534 266C 37 4C                 and   [ScanMaskRef],y          ; do masking
0535 266E 25 CE                 and   DrawMask
0536 2670 51 BC                 eor   (DestRef),y              ; XOR
0537 2672 91 BC                 sta   (DestRef),y              ; and store
0538 2674
0539 2674 A5 C4 29 02           SwapPat 
0540 2683 6B                    rtl   
0541 2684
0542 2684
0543 2684
0544 2684
0545 2684
0546 2684                       ENDP 
0547 2684
0548 2684
0549 2684
0550 2684                       title 'SlabBIC'
0551 2684              ****************************************************************
0552 2684              *
0553 2684              SlabBIC  PROC EXPORT 
0554 2684              *
0555 2684              * This is the routine that is called to BIC patterns to
0556 2684              * the destination when the regions are non-rectangular or the
0557 2684              * penmask is not all $FFFF's.
0558 2684              *
0559 2684              *
0560 2684              * Inputs:
0561 2684              *
0562 2684              *    LeftMask      The Pixels not being touched on the left are
0563 2684              *                  set to zero in this word mask.
0564 2684              *
0565 2684              *    RightMask     The Pixels not being touched on the right are
0566 2684              *                  set to zero in this word mask
0567 2684              *
0568 2684              *    StartWord     The First word on the scan line to deal with
0569 2684              *
0570 2684              *    FinishWord    The last word on the scan line to deal with
0571 2684              *
0572 2684              *    ScanMaskRef   Points to the global scan line clip buffer
0573 2684              *
0574 2684              *    DestRef       Points to the start of the current scan line
0575 2684              *                  (or scan line equiv since can draw into mem).
0576 2684              *
0577 2684              *    PatMask       A mask to use with current index into scan line
0578 2684              *                  to produce an index into Pat.  In 320 mode,
0579 2684              *                  PatMask AND Index will yield 0 or 2.  In 640 mode
0580 2684              *                  it will always yield 0 since pattern fits in
0581 2684              *                  one word
0582 2684              *
0583 2684              *    Pat           Two words to hold the current part of the
0584 2684              *                  pattern being used for this scan line.
0585 2684              *
0586 2684              *    DrawMask      Two words to hold the current slice of the
0587 2684              *                  of the drawing mask.
0588 2684              *
0589 2684              *
0590 2684              *
0591 2684              * Outputs:
0592 2684              *                   none
0593 2684              *
0594 2684              * External Refs:
0595 2684              *                   none
0596 2684              *
0597 2684              * Entry Points:
0598 2684              *                   none
0599 2684              *
0600 2684                       longa on                       ; mode
0601 2684                       longi on
0602 2684              *
0603 2684              * Change History
0604 2684              *
0605 2684              * 08 Sep 88         Steven Glass
0606 2684              *
0607 2684              * Unwound the loop some and took advantage of the expanded
0608 2684              * pattern.
0609 2684              *
0610 2684              * No counters are kept on direct page.
0611 2684              *
0612 2684              ****************************************************************
0613 2684
0614 2684 A5 C4 29 02           swapPat 
0615 2693
0616 2693 A5 C6                 lda   FinishWord               ; put count in x-register
0617 2695 38                    sec   
0618 2696 E5 C4                 sbc   StartWord
0619 2698 4A                    lsr   a                        ; make this num words to xfer - 1
0620 2699 AA                    tax   
0621 269A
0622 269A A4 C4                 ldy   StartWord                ; get the start word in y
0623 269C A5 CA                 lda   Pat                      ; source pattern in a-reg
0624 269E 25 A0                 and   LeftMask
0625 26A0 E0 00 00              cpx   #0                       ; check for special case where only 1 word
0626 26A3 D0 02                 bne   @MoreThanOne
0627 26A5 25 A2                 and   RightMask
0628 26A7 37 4C        @MoreThanOne and   [ScanMaskRef],y      ; do masking
0629 26A9 25 CE                 and   DrawMask
0630 26AB 49 FF FF              eor   #$FFFF                   ; invert
0631 26AE 31 BC                 and   (DestRef),y              ; AND
0632 26B0 91 BC                 sta   (DestRef),y              ; and store
0633 26B2
0634 26B2 E0 00 00              cpx   #0
0635 26B5 F0 3B                 beq   AllDone
0636 26B7
0637 26B7 C8                    iny                            ; bump y and but don't touch x yet
0638 26B8 C8                    iny   
0639 26B9 E0 01 00              cpx   #1                       ; if x is 1 there is one word to go
0640 26BC F0 25                 beq   DoLastWord2
0641 26BE
0642 26BE CA                    dex   
0643 26BF
0644 26BF              InnerLoop  
0645 26BF A5 CC                 lda   Pat+2                    ; source pattern in a-reg
0646 26C1 37 4C                 and   [ScanMaskRef],y          ; do masking
0647 26C3 25 D0                 and   DrawMask+2
0648 26C5 49 FF FF              eor   #$FFFF                   ; invert
0649 26C8 31 BC                 and   (DestRef),y              ; AND
0650 26CA 91 BC                 sta   (DestRef),y              ; and store
0651 26CC
0652 26CC C8                    iny                            ; bump y
0653 26CD C8                    iny   
0654 26CE
0655 26CE CA                    dex                            ; dec x
0656 26CF F0 31                 beq   DoLastWord1              ; if x is zero there is one word to go
0657 26D1
0658 26D1 A5 CA                 lda   Pat
0659 26D3 37 4C                 and   [ScanMaskRef],y
0660 26D5 25 CE                 and   DrawMask
0661 26D7 49 FF FF              eor   #$FFFF                   ; invert
0662 26DA 31 BC                 and   (DestRef),y
0663 26DC 91 BC                 sta   (DestRef),y
0664 26DE
0665 26DE C8                    iny   
0666 26DF C8                    iny   
0667 26E0 CA                    dex   
0668 26E1 D0 DC                 bne   InnerLoop                ; if x is zero there is one word to go
0669 26E3
0670 26E3
0671 26E3              DoLastWord2  
0672 26E3 A5 CC                 lda   Pat+2                    ; source pattern in a-reg
0673 26E5 25 A2                 and   RightMask
0674 26E7 37 4C                 and   [ScanMaskRef],y          ; do masking
0675 26E9 25 D0                 and   DrawMask+2
0676 26EB 49 FF FF              eor   #$FFFF                   ; invert
0677 26EE 31 BC                 and   (DestRef),y              ; AND
0678 26F0 91 BC                 sta   (DestRef),y              ; and store
0679 26F2
0680 26F2 A5 C4 29 02  AllDone  SwapPat 
0681 2701 6B                    rtl   
0682 2702
0683 2702
0684 2702              DoLastWord1  
0685 2702 A5 CA                 lda   Pat                      ; source pattern in a-reg
0686 2704 25 A2                 and   RightMask
0687 2706 37 4C                 and   [ScanMaskRef],y          ; do masking
0688 2708 25 CE                 and   DrawMask
0689 270A 49 FF FF              eor   #$FFFF                   ; invert
0690 270D 31 BC                 and   (DestRef),y              ; XOR
0691 270F 91 BC                 sta   (DestRef),y              ; and store
0692 2711
0693 2711 A5 C4 29 02           SwapPat 
0694 2720 6B                    rtl   
0695 2721
0696 2721
0697 2721
0698 2721
0699 2721
0700 2721                       ENDP 
0701 2721
0702 2721
0703 2721
0704 2721
0705 2721
0706 2721                       title 'FastSlabs'
0707 2721              ****************************************************************
0708 2721              *
0709 2721              * FastSlabs
0710 2721              *
0711 2721              * Summary.
0712 2721              *
0713 2721              * The fast slab routines are called when the object being drawn
0714 2721              * is not clipped to a non-rectangular region and the Drawing mask
0715 2721              * is all FFFF's.  This makes drawing faster since I don't have
0716 2721              * to access the scan line mask buffer and do all the other work
0717 2721              * associated with masking.
0718 2721              *
0719 2721              * All the slab routines use the same data on zero page.
0720 2721              *
0721 2721              * Before any slab routine is called, the data bank register
0722 2721              * is set to the bank containing the pixel image.
0723 2721              *
0724 2721              * The following are set up on zero page before this routine
0725 2721              * is called:
0726 2721              *
0727 2721              * Inputs:
0728 2721              *
0729 2721              *    LeftMask      The Pixels not being touched on the left are
0730 2721              *                  set to zero in this word mask.
0731 2721              *
0732 2721              *    RightMask     The Pixels not being touched on the right are
0733 2721              *                  set to zero in this word mask
0734 2721              *
0735 2721              *    StartWord     The First word on the scan line to deal with
0736 2721              *
0737 2721              *    FinishWord    The last word on the scan line to deal with
0738 2721              *
0739 2721              *    DestRef       Points to the start of the current scan line
0740 2721              *                  (or scan line equiv since can draw into mem).
0741 2721              *
0742 2721              *    Pat           Two words to hold the current part of the
0743 2721              *                  pattern being used for this scan line.
0744 2721              *
0745 2721              *
0746 2721              *
0747 2721              * Variables
0748 2721              *
0749 2721              *    Temp           this is destroyed by the FastCopy and FastXOR
0750 2721              *                   routines. All the other routines don't change
0751 2721              *                   any direct page values
0752 2721              *
0753 2721              *
0754 2721              ****************************************************************
0755 2721
0756 2721
0757 2721
0758 2721
0759 2721                       title 'FastSlabXOR'
0760 2721              ****************************************************************
0761 2721              *
0762 2721              FastSlabXOR PROC EXPORT 
0763 2721              *
0764 2721              * This is the code that is run when QuickDraw discovers
0765 2721              * that the object being drawn is not being clipped to a
0766 2721              * irregular region and the pen mask is all $FFFF.
0767 2721              *
0768 2721              *
0769 2721              * Inputs:
0770 2721              *
0771 2721              *    LeftMask      The Pixels not being touched on the left are
0772 2721              *                  set to zero in this word mask.
0773 2721              *
0774 2721              *    RightMask     The Pixels not being touched on the right are
0775 2721              *                  set to zero in this word mask
0776 2721              *
0777 2721              *    StartWord     The First word on the scan line to deal with
0778 2721              *
0779 2721              *    FinishWord    The last word on the scan line to deal with
0780 2721              *
0781 2721              *    DestRef       Points to the start of the current scan line
0782 2721              *                  (or scan line equiv since can draw into mem).
0783 2721              *
0784 2721              *    Pat           Two words to hold the current part of the
0785 2721              *                  pattern being used for this scan line.
0786 2721              *
0787 2721              *
0788 2721              *
0789 2721              * Variables:
0790 2721              *
0791 2721              *    Temp           this is destroyed.
0792 2721              *
0793 2721              *
0794 2721              *
0795 2721              * Outputs:
0796 2721              *
0797 2721              *    none
0798 2721              *
0799 2721              * External Refs:
0800 2721              *
0801 2721                       IMPORT  IncrementDataBank 
0802 2721              *
0803 2721              * Entry Points:
0804 2721              *
0805 2721              *    none
0806 2721              *
0807 2721                       longa on                       ; mode
0808 2721                       longi on
0809 2721              *
0810 2721              *
0811 2721              * Change History
0812 2721              *
0813 2721              * 09 Sep 88         Steven Glass
0814 2721              *
0815 2721              * Adjusted code to use both words of Pat for all modes.
0816 2721              *
0817 2721              * Wrote new special case code to be used when Pat and Pat+2
0818 2721              * are the same.
0819 2721              *
0820 2721              * No longer writes to direct page.
0821 2721              *
0822 2721              *
0823 2721              * 18 Jan 89         Dave Good
0824 2721              *
0825 2721              * Rewrote to remove iny's from the special case loop. Many other
0826 2721              * changes to remove bytes and cycles. This code now writes to
0827 2721              * direct page again
0828 2721              *
0829 2721              * 3/9/89            Mensch
0830 2721              * Added an Alt entry point for fast rect slabs
0831 2721              *
0832 2721              ****************************************************************
0833 2721              ;---------------------------------------------------------------
0834 2721              MaxWordsInRow equ    80
0835 2721              MaxBytesInRow equ    MaxWordsInRow*2
0836 2721              ;---------------------------------------------------------------
0837 2721                       Export FastSlabXORAlt 
0838 2721                       Export EndXORRazor 
0839 2721              ;---------------------------------------------------------------
0840 2721
0841 2721
0842 2721              ;---------------------------------------------------------------
0843 2721 A5 C4 29 02           SwapPat 
0844 2730
0845 2730 A5 C6                 lda   FinishWord               ;get the number of bytes to XOR into the
0846 2732 38                    sec                            ;..A-Reg
0847 2733 E5 C4                 sbc   StartWord
0848 2735 F0 49                 beq   doSingleWord             ;if only one word, do a special case
0849 2737 4A                    lsr   a
0850 2738 3A                    dec   a                        ;if only two words, then do another
0851 2739 F0 4D                 beq   doLastTwo                ;..special case
0852 273B AA                    tax                            ;otherwise the count goes in X-Reg
0853 273C
0854 273C A5 CA                 lda   Pat                      ;if the patterns are equal go very fast
0855 273E C5 CC                 cmp   Pat+2
0856 2740 F0 54                 beq   GoReallyFast
0857 2742              FastSlabXORAlt  
0858 2742 A4 C4                 ldy   StartWord                ;get the start word in y
0859 2744 A5 CA                 lda   Pat                      ;first source pattern in A-Reg
0860 2746 25 A0                 and   LeftMask
0861 2748 51 BC                 eor   (DestRef),y              ;invert & store it
0862 274A 91 BC                 sta   (DestRef),y
0863 274C C8                    iny                            ;increment our index
0864 274D C8                    iny   
0865 274E              ;---------------------------------------------------------------
0866 274E A5 CC        @loop    lda   Pat+2                    ;second source pattern in A-Reg
0867 2750 51 BC                 eor   (DestRef),y              ;invert & store it
0868 2752 91 BC                 sta   (DestRef),y
0869 2754 C8                    iny                            ;increment our index
0870 2755 C8                    iny   
0871 2756 CA                    dex                            ;decrement our counter
0872 2757 F0 23                 beq   doLastWord1              ;if we're done, then do the last
0873 2759
0874 2759 A5 CA                 lda   Pat                      ;back to first source pattern
0875 275B 51 BC                 eor   (DestRef),y
0876 275D 91 BC                 sta   (DestRef),y
0877 275F C8                    iny   
0878 2760 C8                    iny   
0879 2761 CA                    dex   
0880 2762 D0 EA                 bne   @loop
0881 2764              ;---------------------------------------------------------------
0882 2764 A5 CC        doLastWord2 lda   Pat+2                 	;second source pattern in A-Reg
0883 2766
0884 2766 25 A2        doLastWord and   RightMask
0885 2768 51 BC                 eor   (DestRef),y              ;invert & store it
0886 276A 91 BC                 sta   (DestRef),y
0887 276C A5 C4 29 02           SwapPat 
0888 277B 6B                    rtl   
0889 277C
0890 277C
0891 277C A5 CA        doLastWord1 lda   Pat                   ;first source pattern in A-Reg
0892 277E 80 E6                 bra   doLastWord
0893 2780
0894 2780 A4 C4        doSingleWord ldy   StartWord            ;do only one word
0895 2782 A5 CA                 lda   Pat
0896 2784 25 A0                 and   LeftMask
0897 2786 80 DE                 bra   doLastWord               ;save bytes here by reusing code
0898 2788
0899 2788 A4 C4        doLastTwo ldy   StartWord               ;invert the first word with the first
0900 278A A5 CA                 lda   Pat                      ;..pattern
0901 278C 25 A0                 and   LeftMask
0902 278E 51 BC                 eor   (DestRef),y
0903 2790 91 BC                 sta   (DestRef),y
0904 2792 C8                    iny                            ;move to the second and last word
0905 2793 C8                    iny   
0906 2794 80 CE                 bra   doLastWord2              ;..go invert it with the second pattern
0907 2796              ;---------------------------------------------------------------
0908 2796
0909 2796
0910 2796
0911 2796
0912 2796              ;---------------------------------------------------------------
0913 2796 8B           GoReallyFast phb                        ;save the bank register (we will change it)
0914 2797
0915 2797 A5 C4                 lda   StartWord                ;make Y-Reg a pointer to the first word
0916 2799 18                    clc                            ;..to invert
0917 279A 65 BC                 adc   DestRef
0918 279C A8                    tay   
0919 279D 90 03                 bcc   @1                       ;if Y-Reg overflows, then we must bump the
0920 279F 20 8A 2C              jsr   IncrementDataBank        ;..bank register
0921 27A2              @1        
0922 27A2 A5 CA                 lda   Pat                      ;invert our first word using the only
0923 27A4 25 A0                 and   LeftMask                 ;..pattern and leftMask
0924 27A6 59 00 00              eor   |0,y
0925 27A9 99 00 00              sta   |0,y
0926 27AC 8A                    txa                            ;put our count in X-Reg and our single
0927 27AD A6 CA                 ldx   Pat                      ;..pattern in X-Reg
0928 27AF              ;---------------------------------------------------------------
0929 27AF C9 50 00     rowLoop  cmp   #MaxWordsInRow           ;compare the count with our maximum row size
0930 27B2 90 15                 blt   doLastRow                ;..size. If less, then do last row
0931 27B4 E9 4F 00              sbc   #MaxWordsInRow-1         ;adjust our count (carry is always SET)
0932 27B7 48                    pha                            ;save the count on the stack
0933 27B8 20 F5 27              jsr   DoEntireRow              ;XOR the row
0934 27BB 98                    tya                            ;move our pointer (Y-Reg) past the bytes
0935 27BC 18                    clc                            ;..we just inverted.
0936 27BD 69 A0 00              adc   #MaxBytesInRow
0937 27C0 A8                    tay   
0938 27C1 90 03                 bcc   @noBump                  ;check for overflow
0939 27C3 20 8A 2C              jsr   IncrementDataBank        ;if overflow, then bump the bank
0940 27C6 68           @noBump  pla                            ;get back the count and loop
0941 27C7 80 E6                 bra   rowLoop
0942 27C9              ;---------------------------------------------------------------
0943 27C9 85 2A        doLastRow sta   Temp                    ;save the count in direct page
0944 27CB 0A                    asl   a                        ;multiply the count by seven (the number
0945 27CC 0A                    asl   a                        ;..of bytes of code it takes to XOR one
0946 27CD 0A                    asl   a                        ;..word.)
0947 27CE E5 2A                 sbc   Temp                     ;NOTE: the carry is always CLR here so
0948 27D0 49 FF FF              eor   #$FFFF                   ;..these three lines get us:
0949 27D3 69 23 2A              adc   #EndXORRazor-2           ;..{ EndXORRazor - (count * 7) - 1 }
0950 27D6 F4 DA 27              pea   returnAddr-1             ;this is where we want to return to
0951 27D9 48                    pha   
0952 27DA 60                    rts                            ;jump to our block XOR
0953 27DB              ;---------------------------------------------------------------
0954 27DB AB           returnAddr plb                          ;restore the original bank
0955 27DC A4 C6                 ldy   FinishWord               ;the last word is always at finish word
0956 27DE 8A                    txa                            ;source pattern is still in X-Reg
0957 27DF 25 A2                 and   RightMask
0958 27E1 51 BC                 eor   (DestRef),y
0959 27E3 91 BC                 sta   (DestRef),y              ;and store
0960 27E5 A5 C4 29 02           SwapPat 
0961 27F4 6B                    rtl   
0962 27F5
0963 27F5              ;---------------------------------------------------------------
0964 27F5
0965 27F5
0966 27F5
0967 27F5
0968 27F5              ;---------------------------------------------------------------
0969 27F5              DoEntireRow  
0970 27F5 8A 59 A0 00           EORMultiple 
0971 2A25 60           EndXORRazor rts   
0972 2A26              ;---------------------------------------------------------------
0973 2A26
0974 2A26                       ENDP 
0975 2A26
0976 2A26              ****************************************************************
0977 2A26
0978 2A26
0979 2A26
0980 2A26
0981 2A26                       title 'FastSlabCopy'
0982 2A26              ****************************************************************
0983 2A26              *
0984 2A26              FastSlabCopy PROC EXPORT 
0985 2A26              *
0986 2A26              * This is the code that is run when QuickDraw discovers
0987 2A26              * that the object being drawn is not being clipped to a
0988 2A26              * irregular region and the pen mask is all $FFFF.
0989 2A26              *
0990 2A26              *
0991 2A26              * Inputs:
0992 2A26              *
0993 2A26              *    LeftMask      The Pixels not being touched on the left are
0994 2A26              *                  set to zero in this word mask.
0995 2A26              *
0996 2A26              *    RightMask     The Pixels not being touched on the right are
0997 2A26              *                  set to zero in this word mask
0998 2A26              *
0999 2A26              *    StartWord     The First word on the scan line to deal with
1000 2A26              *
1001 2A26              *    FinishWord    The last word on the scan line to deal with
1002 2A26              *
1003 2A26              *    DestRef       Points to the start of the current scan line
1004 2A26              *                  (or scan line equiv since can draw into mem).
1005 2A26              *
1006 2A26              *    Pat           Two words to hold the current part of the
1007 2A26              *                  pattern being used for this scan line.
1008 2A26              *
1009 2A26              *
1010 2A26              *
1011 2A26              * Variables:
1012 2A26              *
1013 2A26              *    Temp           this is destroyed.
1014 2A26              *
1015 2A26              *
1016 2A26              *
1017 2A26              * Outputs:
1018 2A26              *
1019 2A26              *    none
1020 2A26              *
1021 2A26              * External Refs:
1022 2A26              *
1023 2A26                       IMPORT  IncrementDataBank 
1024 2A26              *
1025 2A26              * Entry Points:
1026 2A26              *                   none
1027 2A26              *
1028 2A26                       longa on                       ; mode
1029 2A26                       longi on
1030 2A26              *
1031 2A26              *
1032 2A26              * Change History
1033 2A26              *
1034 2A26              * 09 Sep 88         Steven Glass
1035 2A26              *
1036 2A26              * Adjusted code to use both words of Pat for all modes.
1037 2A26              *
1038 2A26              * Wrote new special case code to be used when Pat and Pat+2
1039 2A26              * are the same.
1040 2A26              *
1041 2A26              * No longer writes to direct page.
1042 2A26              *
1043 2A26              *
1044 2A26              * 16 Nov 88         Steven Glass
1045 2A26              *
1046 2A26              * The count for MaxInRow was off by one making us draw two few bytes
1047 2A26              * for each time through the loop.
1048 2A26              *
1049 2A26              * Also added an entry in the RowTable for 0 words.  This is
1050 2A26              * unlikely, but possible if the number of words to do is
1051 2A26              * equal to the maxInRow.
1052 2A26              *
1053 2A26              *
1054 2A26              * 18 Jan 89         Dave Good
1055 2A26              *
1056 2A26              * Completely Rewrote to remove iny's from the special case
1057 2A26              * loop. This routine now uses direct page again
1058 2A26              *
1059 2A26              ****************************************************************
1060 2A26              ;---------------------------------------------------------------
1061 2A26              MaxWordsInRow equ   80
1062 2A26              MaxBytesInRow equ   MaxWordsInRow*2
1063 2A26              ;---------------------------------------------------------------
1064 2A26
1065 2A26              ;---------------------------------------------------------------
1066 2A26 A5 C4 29 02           SwapPat 
1067 2A35
1068 2A35 A5 C6                 lda   FinishWord               ;get the number of bytes to copy into
1069 2A37 38                    sec                            ;..A-Reg
1070 2A38 E5 C4                 sbc   StartWord
1071 2A3A F0 49                 beq   doSingleWord             ;if only one word, do a special case
1072 2A3C 4A                    lsr   a
1073 2A3D 3A                    dec   a                        ;if only two words, then do another
1074 2A3E F0 4F                 beq   doLastTwo                ;..special case
1075 2A40 AA                    tax                            ;otherwise the count goes in X-Reg
1076 2A41
1077 2A41 A5 CA                 lda   Pat                      ;if the patterns are equal go very fast
1078 2A43 C5 CC                 cmp   Pat+2
1079 2A45 F0 58                 beq   GoReallyFast
1080 2A47                       Export FastSlabCopyAlt 
1081 2A47              FastSlabCopyAlt  
1082 2A47 A4 C4                 ldy   StartWord                ;get the start word in Y-Reg
1083 2A49 A5 CA                 lda   Pat                      ;first source pattern in A-Reg
1084 2A4B 51 BC                 eor   (DestRef),y              ;clip with the mask properly
1085 2A4D 25 A0                 and   LeftMask
1086 2A4F 51 BC                 eor   (DestRef),y
1087 2A51 91 BC                 sta   (DestRef),y              ;and store
1088 2A53 C8                    iny                            ;increment our index
1089 2A54 C8                    iny   
1090 2A55              ;---------------------------------------------------------------
1091 2A55 A5 CC        @loop    lda   Pat+2                    ;second source pattern in A-Reg
1092 2A57 91 BC                 sta   (DestRef),y
1093 2A59 C8                    iny                            ;increment our index
1094 2A5A C8                    iny   
1095 2A5B CA                    dex                            ;decrement our counter
1096 2A5C F0 23                 beq   doLastWord1              ;if we're done, then do the last
1097 2A5E
1098 2A5E A5 CA                 lda   Pat
1099 2A60 91 BC                 sta   (DestRef),y
1100 2A62 C8                    iny   
1101 2A63 C8                    iny   
1102 2A64 CA                    dex   
1103 2A65 D0 EE                 bne   @loop
1104 2A67              ;---------------------------------------------------------------
1105 2A67 A5 CC        doLastWord2 lda   Pat+2                 ;second source pattern in A-Reg
1106 2A69
1107 2A69 51 BC        doLastWord eor   (DestRef),y            ;clip with the mask properly
1108 2A6B 25 A2        exit     and   RightMask
1109 2A6D 51 BC                 eor   (DestRef),y
1110 2A6F 91 BC                 sta   (DestRef),y              ;and store
1111 2A71 A5 C4 29 02           SwapPat 
1112 2A80 6B                    rtl   
1113 2A81
1114 2A81
1115 2A81 A5 CA        doLastWord1 lda   Pat                   ;first source pattern in a-reg
1116 2A83 80 E4                 bra   doLastWord
1117 2A85
1118 2A85 A4 C4        doSingleWord ldy   StartWord            ;do the first and only word here using
1119 2A87 A5 CA                 lda   Pat                      ;..the first source pattern
1120 2A89 51 BC                 eor   (DestRef),y
1121 2A8B 25 A0                 and   LeftMask
1122 2A8D 80 DC                 bra   exit                     ;save bytes here
1123 2A8F
1124 2A8F A4 C4        doLastTwo ldy   StartWord               ;do the first word here with the first
1125 2A91 A5 CA                 lda   Pat                      ;source pattern
1126 2A93 51 BC                 eor   (DestRef),y
1127 2A95 25 A0                 and   LeftMask
1128 2A97 51 BC                 eor   (DestRef),y
1129 2A99 91 BC                 sta   (DestRef),y
1130 2A9B C8                    iny                            ;move to the next and last word and use
1131 2A9C C8                    iny                            ;..the second source pattern.
1132 2A9D 80 C8                 bra   doLastWord2              ;save bytes here
1133 2A9F              ;---------------------------------------------------------------
1134 2A9F
1135 2A9F
1136 2A9F
1137 2A9F
1138 2A9F              ;---------------------------------------------------------------
1139 2A9F 8B           GoReallyFast phb                        ;save the bank register (we will change it)
1140 2AA0
1141 2AA0 A5 C4                 lda   StartWord                ;make Y-Reg into a pointer to the first
1142 2AA2 18                    clc                            ;..word
1143 2AA3 65 BC                 adc   DestRef
1144 2AA5 A8                    tay   
1145 2AA6 90 03                 bcc   @1                       ;if Y-Reg overflows, then we must bump
1146 2AA8 20 8A 2C              jsr   IncrementDataBank        ;..the bank register
1147 2AAB              @1        
1148 2AAB A5 CA                 lda   Pat                      ;copy into the first word using leftMask
1149 2AAD 59 00 00              eor   |0,y                     ;..to clip it.
1150 2AB0 25 A0                 and   LeftMask
1151 2AB2 59 00 00              eor   |0,y
1152 2AB5 99 00 00              sta   |0,y
1153 2AB8 8A                    txa                            ;put our counter in the A-Reg
1154 2AB9              ;---------------------------------------------------------------
1155 2AB9 C9 50 00     rowLoop  cmp   #MaxWordsInRow           ;compare the count with our maximum row size
1156 2ABC 90 17                 blt   doLastRow                ;..size. If less, then do last row
1157 2ABE E9 4F 00              sbc   #MaxWordsInRow-1         ;adjust our count (carry is always SET)
1158 2AC1 48                    pha                            ;save the count on the stack
1159 2AC2 A5 CA                 lda   Pat
1160 2AC4 20 F9 2A              jsr   DoEntireRow              ;COPY the row
1161 2AC7 98                    tya                            ;move our pointer (Y-Reg) past the bytes
1162 2AC8 18                    clc                            ;..we just inverted.
1163 2AC9 69 A0 00              adc   #MaxBytesInRow
1164 2ACC A8                    tay   
1165 2ACD 90 03                 bcc   @noBump                  ;check for overflow
1166 2ACF 20 8A 2C              jsr   IncrementDataBank        ;if overflow, then bump the bank
1167 2AD2 68           @noBump  pla                            ;get back the count and loop
1168 2AD3 80 E4                 bra   rowLoop
1169 2AD5              ;---------------------------------------------------------------
1170 2AD5 0A           doLastRow asl   a                       ;multiply the count by two and use this
1171 2AD6 AA                    tax                            ;..as our index into the jump table
1172 2AD7 A5 CA                 lda   Pat
1173 2AD9 FC EA 2B              jsr   (JumpTable,x)
1174 2ADC              ;---------------------------------------------------------------
1175 2ADC AB           returnAddr plb                          ;restore the original data bank
1176 2ADD A4 C6                 ldy   FinishWord               ;the last word is always at finish word
1177 2ADF A5 CA                 lda   Pat                      ;only source pattern in a-reg
1178 2AE1 51 BC                 eor   (DestRef),y              ;clip with the mask properly
1179 2AE3 25 A2                 and   RightMask
1180 2AE5 51 BC                 eor   (DestRef),y
1181 2AE7 91 BC                 sta   (DestRef),y              ;and store
1182 2AE9 A5 C4 29 02           SwapPat 
1183 2AF8 6B                    rtl   
1184 2AF9
1185 2AF9              ;---------------------------------------------------------------
1186 2AF9
1187 2AF9
1188 2AF9
1189 2AF9
1190 2AF9              ;---------------------------------------------------------------
1191 2AF9              DoEntireRow  
1192 2AF9 99 A0 00 99           STAMultiple 
1193 2BE9 60           EndAddr  rts   
1194 2BEA              ;---------------------------------------------------------------
1195 2BEA                       Export CopyJumpTable 
1196 2BEA              CopyJumpTable  
1197 2BEA E9 2B E6 2B  JumpTable MakeJumpTable 
1198 2C8A              ;---------------------------------------------------------------
1199 2C8A
1200 2C8A                       ENDP 
1201 2C8A
1202 2C8A              ****************************************************************
1203 2C8A
1204 2C8A
1205 2C8A
1206 2C8A
1207 2C8A                       title 'IncrementDataBank'
1208 2C8A              ****************************************************************
1209 2C8A              *
1210 2C8A              IncrementDataBank PROC ENTRY 
1211 2C8A              *
1212 2C8A              * This increments the bank register by one
1213 2C8A              *
1214 2C8A              *
1215 2C8A              * Inputs:
1216 2C8A              *
1217 2C8A              *    none
1218 2C8A              *
1219 2C8A              * Outputs:
1220 2C8A              *
1221 2C8A              *    none
1222 2C8A              *
1223 2C8A              * External Refs:
1224 2C8A              *                   none
1225 2C8A              *
1226 2C8A              * Entry Points:
1227 2C8A              *                   none
1228 2C8A              *
1229 2C8A                       longa on                       ; mode
1230 2C8A                       longi on
1231 2C8A              *
1232 2C8A              *
1233 2C8A              * Change History
1234 2C8A              *
1235 2C8A              * 03 Feb 89         Dave Good
1236 2C8A              *
1237 2C8A              * This routine is used by FastSlabCopy and FastSlabXOR to
1238 2C8A              * increment the data bank.
1239 2C8A              *
1240 2C8A              *
1241 2C8A              ****************************************************************
1242 2C8A
1243 2C8A 8B                    phb                            ;put the data bank on the stack
1244 2C8B 68                    pla                            ;get back $xxbb where bb is the data bank
1245 2C8C 1A                    inc   a                        ;increment the bank. Note: this will NEVER
1246 2C8D 48                    pha                            ;..wrap to the next byte
1247 2C8E AB                    plb                            ;get the data bank back in B
1248 2C8F 60                    rts   
1249 2C90
1250 2C90                       ENDP 
1251 2C90
1252 2C90              ****************************************************************
1253 2C90
1254 2C90
1255 2C90
1256 2C90
1257 2C90
1258 2C90                       title 'FastSlabOr'
1259 2C90              ****************************************************************
1260 2C90              *
1261 2C90              FastSlabOr PROC EXPORT 
1262 2C90              *
1263 2C90              * This is the code that is run when QuickDraw discovers
1264 2C90              * that the object being drawn is not being clipped to a
1265 2C90              * irregular region and the pen mask is all $FFFF.
1266 2C90              *
1267 2C90              *
1268 2C90              * Inputs:
1269 2C90              *
1270 2C90              *    LeftMask      The Pixels not being touched on the left are
1271 2C90              *                  set to zero in this word mask.
1272 2C90              *
1273 2C90              *    RightMask     The Pixels not being touched on the right are
1274 2C90              *                  set to zero in this word mask
1275 2C90              *
1276 2C90              *    StartWord     The First word on the scan line to deal with
1277 2C90              *
1278 2C90              *    FinishWord    The last word on the scan line to deal with
1279 2C90              *
1280 2C90              *    DestRef       Points to the start of the current scan line
1281 2C90              *                  (or scan line equiv since can draw into mem).
1282 2C90              *
1283 2C90              *    Pat           Two words to hold the current part of the
1284 2C90              *                  pattern being used for this scan line.
1285 2C90              *
1286 2C90              *
1287 2C90              *
1288 2C90              *
1289 2C90              * Outputs:
1290 2C90              *
1291 2C90              *    none
1292 2C90              *
1293 2C90              * External Refs:
1294 2C90              *                   none
1295 2C90              *
1296 2C90              * Entry Points:
1297 2C90              *           none
1298 2C90              *
1299 2C90                       longa on                       ; mode
1300 2C90                       longi on
1301 2C90              *
1302 2C90              ****************************************************************
1303 2C90
1304 2C90 A5 C4 29 02           swapPat 
1305 2C9F
1306 2C9F A5 C6                 lda   FinishWord               ; put count in x-register
1307 2CA1 38                    sec   
1308 2CA2 E5 C4                 sbc   StartWord
1309 2CA4 4A                    lsr   a                        ; div by 2 so holds num words to xfer - 1
1310 2CA5 AA                    tax   
1311 2CA6
1312 2CA6              ;	lda	StartWord	; get the start word in y
1313 2CA6              ;	clc		; this carry is already always cleared by lsr above
1314 2CA6              ;	adc	destRef
1315 2CA6              ;	tay		; this is the offset to out slab...
1316 2CA6
1317 2CA6 A4 C4                 ldy   StartWord
1318 2CA8 A5 CA                 lda   Pat                      ; source pattern in a-reg
1319 2CAA 25 A0                 and   LeftMask
1320 2CAC E0 00 00              cpx   #0                       ; check for special case where only 1 word
1321 2CAF D0 02                 bne   @MoreThanOne
1322 2CB1 25 A2                 and   RightMask
1323 2CB3 11 BC        @MoreThanOne ora   (destRef),y          ; invert again
1324 2CB5 91 BC                 sta   (destRef),y              ; and store
1325 2CB7
1326 2CB7 E0 00 00              cpx   #0
1327 2CBA F0 25                 beq   AllDone
1328 2CBC
1329 2CBC C8                    iny                            ; bump y and but don't touch x yet
1330 2CBD C8                    iny   
1331 2CBE CA                    dex                            ; dec x since one word is done
1332 2CBF D0 02                 bne   innerLoop
1333 2CC1 80 16                 bra   DoLastWord2
1334 2CC3              innerLoop  
1335 2CC3              ;	txa
1336 2CC3              ;	asl	a
1337 2CC3              ;	pha
1338 2CC3              ;
1339 2CC3              ; the following code was generated with the following MPW shell script
1340 2CC3              ; use it in good health commander
1341 2CC3              ;set x 8
1342 2CC3              ;set y 0
1343 2CC3              ;Loop
1344 2CC3              ;    echo " tlda pat+2" ;
1345 2CC3              ;    echo " teor |{y},y" ;
1346 2CC3              ;    echo " tsta |{y},y" ;
1347 2CC3              ;    echo " tdex"
1348 2CC3              ;    echo " tbeq DoLastWord2"
1349 2CC3              ;                    set y `evaluate {y}+2`;
1350 2CC3              ;    echo " tlda pat" ;
1351 2CC3              ;    echo " teor |{y},y" ;
1352 2CC3              ;    echo " tsta |{y},y" ;
1353 2CC3              ;    echo " tdex"
1354 2CC3              ;    echo " tbeq DoLastWord1"
1355 2CC3              ;                    set y `evaluate {y}+2`;
1356 2CC3              ;    set x `evaluate {x}-1` ;
1357 2CC3              ;    If {X}>1 
1358 2CC3              ;        continue
1359 2CC3              ;    else
1360 2CC3              ;        break
1361 2CC3              ;    end;
1362 2CC3              ;End  
1363 2CC3
1364 2CC3 A5 CC                 lda   Pat+2                    ; source pattern in a-reg
1365 2CC5 11 BC                 ora   (DestRef),y              ; OR
1366 2CC7 91 BC                 sta   (DestRef),y              ; and store;;
1367 2CC9
1368 2CC9 C8                    iny                            ; bump y
1369 2CCA C8                    iny                            ;
1370 2CCB
1371 2CCB CA                    dex                            ; dec x
1372 2CCC F0 23                 beq   DoLastWord1              ; if x is zero there is one word to go;
1373 2CCE
1374 2CCE A5 CA                 lda   Pat
1375 2CD0 11 BC                 ora   (DestRef),y              ; OR
1376 2CD2 91 BC                 sta   (DestRef),y              ; and store;
1377 2CD4
1378 2CD4 C8                    iny   
1379 2CD5 C8                    iny   
1380 2CD6 CA                    dex   
1381 2CD7 D0 EA                 bne   InnerLoop                ; if x is zero there is one word to go
1382 2CD9
1383 2CD9              DoLastWord2  
1384 2CD9 A5 CC                 lda   Pat+2                    ; source pattern in a-reg
1385 2CDB 25 A2                 and   RightMask
1386 2CDD 11 BC                 ora   (DestRef),y              ; OR
1387 2CDF 91 BC                 sta   (DestRef),y              ; and store
1388 2CE1
1389 2CE1 A5 C4 29 02  AllDone  SwapPat 
1390 2CF0 6B                    rtl   
1391 2CF1
1392 2CF1
1393 2CF1              DoLastWord1  
1394 2CF1 A5 CA                 lda   Pat                      ; source pattern in a-reg
1395 2CF3 25 A2                 and   RightMask
1396 2CF5 11 BC                 ora   (DestRef),y              ; OR
1397 2CF7 91 BC                 sta   (DestRef),y              ; and store
1398 2CF9
1399 2CF9 A5 C4 29 02           SwapPat 
1400 2D08 6B                    rtl   
1401 2D09
1402 2D09
1403 2D09                       ENDP 
1404 2D09
1405 2D09
1406 2D09
1407 2D09                       title 'FastSlabBIC'
1408 2D09              ****************************************************************
1409 2D09              *
1410 2D09              FastSlabBIC PROC EXPORT 
1411 2D09              *
1412 2D09              * This is the code that is run when QuickDraw discovers
1413 2D09              * that the object being drawn is not being clipped to a
1414 2D09              * irregular region and the pen mask is all $FFFF.
1415 2D09              *
1416 2D09              *
1417 2D09              * Inputs:
1418 2D09              *
1419 2D09              *    LeftMask      The Pixels not being touched on the left are
1420 2D09              *                  set to zero in this word mask.
1421 2D09              *
1422 2D09              *    RightMask     The Pixels not being touched on the right are
1423 2D09              *                  set to zero in this word mask
1424 2D09              *
1425 2D09              *    StartWord     The First word on the scan line to deal with
1426 2D09              *
1427 2D09              *    FinishWord    The last word on the scan line to deal with
1428 2D09              *
1429 2D09              *    DestRef       Points to the start of the current scan line
1430 2D09              *                  (or scan line equiv since can draw into mem).
1431 2D09              *
1432 2D09              *    Pat           Two words to hold the current part of the
1433 2D09              *                  pattern being used for this scan line.
1434 2D09              *
1435 2D09              *
1436 2D09              *
1437 2D09              *
1438 2D09              * Outputs:
1439 2D09              *
1440 2D09              *    none
1441 2D09              *
1442 2D09              * External Refs:
1443 2D09              *                   none
1444 2D09              *
1445 2D09              * Entry Points:
1446 2D09              *                   none
1447 2D09              *
1448 2D09                       longa on                       ; mode
1449 2D09                       longi on
1450 2D09              *
1451 2D09              ****************************************************************
1452 2D09 A5 C4 29 02           SwapPat 
1453 2D18
1454 2D18
1455 2D18 A5 C6                 lda   FinishWord               ; put count in x-register
1456 2D1A 38                    sec   
1457 2D1B E5 C4                 sbc   StartWord
1458 2D1D 4A                    lsr   a                        ; div by 2 so holds num words to xfer - 1
1459 2D1E AA                    tax   
1460 2D1F
1461 2D1F A4 C4                 ldy   StartWord                ; get the start word in y
1462 2D21 A5 CA                 lda   Pat                      ; source pattern in a-reg
1463 2D23 25 A0                 and   LeftMask
1464 2D25 E0 00 00              cpx   #0                       ; check for special case where only 1 word
1465 2D28 D0 02                 bne   @MoreThanOne
1466 2D2A 25 A2                 and   RightMask
1467 2D2C 49 FF FF     @MoreThanOne eor   #$FFFF               ; INVERT
1468 2D2F 31 BC                 and   (DestRef),y              ; AND
1469 2D31 91 BC                 sta   (DestRef),y              ; and store
1470 2D33
1471 2D33 E0 00 00              cpx   #0
1472 2D36 F0 2F                 beq   AllDone
1473 2D38
1474 2D38 C8                    iny                            ; bump y and but don't touch x yet
1475 2D39 C8                    iny   
1476 2D3A E0 01 00              cpx   #1                       ; if x is 1 there is one word to go
1477 2D3D F0 1D                 beq   DoLastWord2
1478 2D3F
1479 2D3F CA                    dex                            ; dec x since one word is done
1480 2D40
1481 2D40              InnerLoop  
1482 2D40 A5 CC                 lda   Pat+2                    ; source pattern in a-reg
1483 2D42 49 FF FF              eor   #$FFFF                   ; Invert
1484 2D45 31 BC                 and   (DestRef),y              ; AND
1485 2D47 91 BC                 sta   (DestRef),y              ; and store
1486 2D49
1487 2D49 C8                    iny                            ; bump y
1488 2D4A C8                    iny   
1489 2D4B
1490 2D4B CA                    dex                            ; dec x
1491 2D4C F0 29                 beq   DoLastWord1              ; if x is zero there is one word to go
1492 2D4E
1493 2D4E A5 CA                 lda   Pat
1494 2D50 49 FF FF              eor   #$FFFF                   ; INVERT
1495 2D53 31 BC                 and   (DestRef),y              ; AND
1496 2D55 91 BC                 sta   (DestRef),y              ; and store
1497 2D57
1498 2D57 C8                    iny   
1499 2D58 C8                    iny   
1500 2D59 CA                    dex   
1501 2D5A D0 E4                 bne   InnerLoop                ; if x is zero there is one word to go (fall through)
1502 2D5C
1503 2D5C
1504 2D5C              DoLastWord2  
1505 2D5C A5 CC                 lda   Pat+2                    ; source pattern in a-reg
1506 2D5E 25 A2                 and   RightMask
1507 2D60 49 FF FF              eor   #$FFFF                   ; invert
1508 2D63 31 BC                 and   (DestRef),y              ; AND
1509 2D65 91 BC                 sta   (DestRef),y              ; and store
1510 2D67 A5 C4 29 02  AllDone  SwapPat 
1511 2D76 6B                    rtl   
1512 2D77
1513 2D77
1514 2D77
1515 2D77
1516 2D77
1517 2D77              DoLastWord1  
1518 2D77 A5 CA                 lda   Pat                      ; source pattern in a-reg
1519 2D79 25 A2                 and   RightMask
1520 2D7B 49 FF FF              eor   #$FFFF                   ; invert
1521 2D7E 31 BC                 and   (DestRef),y              ; AND
1522 2D80 91 BC                 sta   (DestRef),y              ; and store
1523 2D82 A5 C4 29 02           SwapPat 
1524 2D91 6B                    rtl   
1525 2D92
1526 2D92
1527 2D92
1528 2D92                       ENDP 
1529 2D92
1530 2D92
1531 2D92
1532 2D92
1533 2D92                       END   
